package mcfall.raytracer.objects;

import mcfall.raytracer.Intensity;

/**
 * This class holds three intensity objects, one each for 
 * red, green, and blue components
 * @author mcfall
 *
 */
public class RGBIntensity {
	private Intensity red;
	private Intensity green;
	private Intensity blue;
	
	/**
	 * Creates a new RGB intensity object with the specified values
	 * @param red
	 * @param green
	 * @param blue
	 */
	public RGBIntensity (double red, double green, double blue) {
		this.red = new Intensity(red);
		this.green = new Intensity(green);
		this.blue = new Intensity(blue);
	}
	
	/**
	 * Blends this color with the color <i>other</i>, ensuring that the
	 * values are clamped at one
	 * @param other another RGBIntensity value to add to this color
	 */
	public void add(RGBIntensity other) {
		red.add(other.getRed());
		green.add(other.getGreen());
		blue.add(other.getBlue());
	}
	
	public double getRed () {
		return red.getValue();
	}
	
	public double getGreen () {
		return green.getValue ();
	}
	
	public double getBlue () {
		return blue.getValue();
	}
	
	public String toString () {
		return "(" + red.getValue() + ", " + green.getValue() + ", " + blue.getValue() + ")";
	}
	public RGBIntensity fade(double percent)
	{
		return new RGBIntensity(red.getValue()*percent,green.getValue()*percent,blue.getValue()*percent);
	}
}
